/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileDistributor
extends TileMod
implements IManaReceiver {
    private final List<IManaReceiver> validPools = new ArrayList<IManaReceiver>();

    public TileDistributor(BlockPos pos, BlockState state) {
        super(ModTiles.DISTRIBUTOR, pos, state);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TileDistributor self) {
        self.validPools.clear();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            IManaReceiver receiver;
            BlockPos pos = worldPosition.m_142300_(dir);
            if (!level.m_46805_(pos) || !((receiver = IXplatAbstractions.INSTANCE.findManaReceiver(level, pos, dir.m_122424_())) instanceof IManaPool) || receiver.isFull()) continue;
            self.validPools.add(receiver);
        }
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return 0;
    }

    @Override
    public boolean isFull() {
        return this.validPools.isEmpty();
    }

    @Override
    public void receiveMana(int mana) {
        int tiles = this.validPools.size();
        if (tiles != 0) {
            int manaForEach = mana / tiles;
            for (IManaReceiver pool : this.validPools) {
                pool.receiveMana(manaForEach);
            }
        }
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }
}

